package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._

/** MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. */
final case class MutatingWebhookConfiguration(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  webhooks : Option[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "MutatingWebhookConfiguration", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : MutatingWebhookConfiguration = copy(metadata = Some(value))
  def withWebhooks(value: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]) : MutatingWebhookConfiguration = copy(webhooks = Some(value))
  def addWebhooks(newValues: io.k8s.api.admissionregistration.v1.MutatingWebhook*) : MutatingWebhookConfiguration = copy(webhooks = Some(webhooks.fold(newValues)(_ ++ newValues)))

}

