package io.k8s.api.admissionregistration.v1


/** MutatingWebhook describes an admission webhook and the resources and operations it applies to. */
final case class MutatingWebhook(
  timeoutSeconds : Option[Int] = None,
  name : String,
  matchPolicy : Option[String] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  sideEffects : String,
  clientConfig : io.k8s.api.admissionregistration.v1.WebhookClientConfig,
  failurePolicy : Option[String] = None,
  reinvocationPolicy : Option[String] = None,
  rules : Option[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]] = None,
  admissionReviewVersions : Seq[String],
  objectSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withTimeoutSeconds(value: Int) : MutatingWebhook = copy(timeoutSeconds = Some(value))
  def withName(value: String) : MutatingWebhook = copy(name = value)
  def withMatchPolicy(value: String) : MutatingWebhook = copy(matchPolicy = Some(value))
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(namespaceSelector = Some(value))
  def withSideEffects(value: String) : MutatingWebhook = copy(sideEffects = value)
  def withClientConfig(value: io.k8s.api.admissionregistration.v1.WebhookClientConfig) : MutatingWebhook = copy(clientConfig = value)
  def withFailurePolicy(value: String) : MutatingWebhook = copy(failurePolicy = Some(value))
  def withReinvocationPolicy(value: String) : MutatingWebhook = copy(reinvocationPolicy = Some(value))
  def withRules(value: Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]) : MutatingWebhook = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.admissionregistration.v1.RuleWithOperations*) : MutatingWebhook = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

  def withAdmissionReviewVersions(value: Seq[String]) : MutatingWebhook = copy(admissionReviewVersions = value)
  def addAdmissionReviewVersions(newValues: String*) : MutatingWebhook = copy(admissionReviewVersions = admissionReviewVersions ++ newValues)

  def withObjectSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(objectSelector = Some(value))
}

