package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PersistentVolumeSpec is the specification of a persistent volume. */
final case class PersistentVolumeSpec(
  scaleIO : Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = None,
  csi : Option[io.k8s.api.core.v1.CSIPersistentVolumeSource] = None,
  accessModes : Option[Seq[String]] = None,
  mountOptions : Option[Seq[String]] = None,
  nodeAffinity : Option[io.k8s.api.core.v1.VolumeNodeAffinity] = None,
  azureDisk : Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile : Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = None,
  hostPath : Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  rbd : Option[io.k8s.api.core.v1.RBDPersistentVolumeSource] = None,
  portworxVolume : Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  persistentVolumeReclaimPolicy : Option[String] = None,
  glusterfs : Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = None,
  volumeMode : Option[String] = None,
  flocker : Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  claimRef : Option[io.k8s.api.core.v1.ObjectReference] = None,
  fc : Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  local : Option[io.k8s.api.core.v1.LocalVolumeSource] = None,
  storageClassName : Option[String] = None,
  photonPersistentDisk : Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  gcePersistentDisk : Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  vsphereVolume : Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None,
  iscsi : Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = None,
  cinder : Option[io.k8s.api.core.v1.CinderPersistentVolumeSource] = None,
  cephfs : Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = None,
  awsElasticBlockStore : Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  flexVolume : Option[io.k8s.api.core.v1.FlexPersistentVolumeSource] = None,
  nfs : Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  quobyte : Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  storageos : Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with scaleIO set to new value */
  def withScaleIO(value: io.k8s.api.core.v1.ScaleIOPersistentVolumeSource) : PersistentVolumeSpec = copy(scaleIO = Some(value))
  /** if scaleIO has a value, transforms to the result of function*/
  def mapScaleIO(f: io.k8s.api.core.v1.ScaleIOPersistentVolumeSource => io.k8s.api.core.v1.ScaleIOPersistentVolumeSource) : PersistentVolumeSpec = copy(scaleIO = scaleIO.map(f))

  /** Returns a new data with csi set to new value */
  def withCsi(value: io.k8s.api.core.v1.CSIPersistentVolumeSource) : PersistentVolumeSpec = copy(csi = Some(value))
  /** if csi has a value, transforms to the result of function*/
  def mapCsi(f: io.k8s.api.core.v1.CSIPersistentVolumeSource => io.k8s.api.core.v1.CSIPersistentVolumeSource) : PersistentVolumeSpec = copy(csi = csi.map(f))

  /** Returns a new data with accessModes set to new value */
  def withAccessModes(value: Seq[String]) : PersistentVolumeSpec = copy(accessModes = Some(value))
  /** Appends new values to accessModes */
  def addAccessModes(newValues: String*) : PersistentVolumeSpec = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))
  /** if accessModes has a value, transforms to the result of function*/
  def mapAccessModes(f: Seq[String] => Seq[String]) : PersistentVolumeSpec = copy(accessModes = accessModes.map(f))

  /** Returns a new data with mountOptions set to new value */
  def withMountOptions(value: Seq[String]) : PersistentVolumeSpec = copy(mountOptions = Some(value))
  /** Appends new values to mountOptions */
  def addMountOptions(newValues: String*) : PersistentVolumeSpec = copy(mountOptions = Some(mountOptions.fold(newValues)(_ ++ newValues)))
  /** if mountOptions has a value, transforms to the result of function*/
  def mapMountOptions(f: Seq[String] => Seq[String]) : PersistentVolumeSpec = copy(mountOptions = mountOptions.map(f))

  /** Returns a new data with nodeAffinity set to new value */
  def withNodeAffinity(value: io.k8s.api.core.v1.VolumeNodeAffinity) : PersistentVolumeSpec = copy(nodeAffinity = Some(value))
  /** if nodeAffinity has a value, transforms to the result of function*/
  def mapNodeAffinity(f: io.k8s.api.core.v1.VolumeNodeAffinity => io.k8s.api.core.v1.VolumeNodeAffinity) : PersistentVolumeSpec = copy(nodeAffinity = nodeAffinity.map(f))

  /** Returns a new data with azureDisk set to new value */
  def withAzureDisk(value: io.k8s.api.core.v1.AzureDiskVolumeSource) : PersistentVolumeSpec = copy(azureDisk = Some(value))
  /** if azureDisk has a value, transforms to the result of function*/
  def mapAzureDisk(f: io.k8s.api.core.v1.AzureDiskVolumeSource => io.k8s.api.core.v1.AzureDiskVolumeSource) : PersistentVolumeSpec = copy(azureDisk = azureDisk.map(f))

  /** Returns a new data with azureFile set to new value */
  def withAzureFile(value: io.k8s.api.core.v1.AzureFilePersistentVolumeSource) : PersistentVolumeSpec = copy(azureFile = Some(value))
  /** if azureFile has a value, transforms to the result of function*/
  def mapAzureFile(f: io.k8s.api.core.v1.AzureFilePersistentVolumeSource => io.k8s.api.core.v1.AzureFilePersistentVolumeSource) : PersistentVolumeSpec = copy(azureFile = azureFile.map(f))

  /** Returns a new data with hostPath set to new value */
  def withHostPath(value: io.k8s.api.core.v1.HostPathVolumeSource) : PersistentVolumeSpec = copy(hostPath = Some(value))
  /** if hostPath has a value, transforms to the result of function*/
  def mapHostPath(f: io.k8s.api.core.v1.HostPathVolumeSource => io.k8s.api.core.v1.HostPathVolumeSource) : PersistentVolumeSpec = copy(hostPath = hostPath.map(f))

  /** Returns a new data with rbd set to new value */
  def withRbd(value: io.k8s.api.core.v1.RBDPersistentVolumeSource) : PersistentVolumeSpec = copy(rbd = Some(value))
  /** if rbd has a value, transforms to the result of function*/
  def mapRbd(f: io.k8s.api.core.v1.RBDPersistentVolumeSource => io.k8s.api.core.v1.RBDPersistentVolumeSource) : PersistentVolumeSpec = copy(rbd = rbd.map(f))

  /** Returns a new data with portworxVolume set to new value */
  def withPortworxVolume(value: io.k8s.api.core.v1.PortworxVolumeSource) : PersistentVolumeSpec = copy(portworxVolume = Some(value))
  /** if portworxVolume has a value, transforms to the result of function*/
  def mapPortworxVolume(f: io.k8s.api.core.v1.PortworxVolumeSource => io.k8s.api.core.v1.PortworxVolumeSource) : PersistentVolumeSpec = copy(portworxVolume = portworxVolume.map(f))

  /** Returns a new data with persistentVolumeReclaimPolicy set to new value */
  def withPersistentVolumeReclaimPolicy(value: String) : PersistentVolumeSpec = copy(persistentVolumeReclaimPolicy = Some(value))
  /** if persistentVolumeReclaimPolicy has a value, transforms to the result of function*/
  def mapPersistentVolumeReclaimPolicy(f: String => String) : PersistentVolumeSpec = copy(persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy.map(f))

  /** Returns a new data with glusterfs set to new value */
  def withGlusterfs(value: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource) : PersistentVolumeSpec = copy(glusterfs = Some(value))
  /** if glusterfs has a value, transforms to the result of function*/
  def mapGlusterfs(f: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource => io.k8s.api.core.v1.GlusterfsPersistentVolumeSource) : PersistentVolumeSpec = copy(glusterfs = glusterfs.map(f))

  /** Returns a new data with volumeMode set to new value */
  def withVolumeMode(value: String) : PersistentVolumeSpec = copy(volumeMode = Some(value))
  /** if volumeMode has a value, transforms to the result of function*/
  def mapVolumeMode(f: String => String) : PersistentVolumeSpec = copy(volumeMode = volumeMode.map(f))

  /** Returns a new data with flocker set to new value */
  def withFlocker(value: io.k8s.api.core.v1.FlockerVolumeSource) : PersistentVolumeSpec = copy(flocker = Some(value))
  /** if flocker has a value, transforms to the result of function*/
  def mapFlocker(f: io.k8s.api.core.v1.FlockerVolumeSource => io.k8s.api.core.v1.FlockerVolumeSource) : PersistentVolumeSpec = copy(flocker = flocker.map(f))

  /** Returns a new data with claimRef set to new value */
  def withClaimRef(value: io.k8s.api.core.v1.ObjectReference) : PersistentVolumeSpec = copy(claimRef = Some(value))
  /** if claimRef has a value, transforms to the result of function*/
  def mapClaimRef(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : PersistentVolumeSpec = copy(claimRef = claimRef.map(f))

  /** Returns a new data with fc set to new value */
  def withFc(value: io.k8s.api.core.v1.FCVolumeSource) : PersistentVolumeSpec = copy(fc = Some(value))
  /** if fc has a value, transforms to the result of function*/
  def mapFc(f: io.k8s.api.core.v1.FCVolumeSource => io.k8s.api.core.v1.FCVolumeSource) : PersistentVolumeSpec = copy(fc = fc.map(f))

  /** Returns a new data with local set to new value */
  def withLocal(value: io.k8s.api.core.v1.LocalVolumeSource) : PersistentVolumeSpec = copy(local = Some(value))
  /** if local has a value, transforms to the result of function*/
  def mapLocal(f: io.k8s.api.core.v1.LocalVolumeSource => io.k8s.api.core.v1.LocalVolumeSource) : PersistentVolumeSpec = copy(local = local.map(f))

  /** Returns a new data with storageClassName set to new value */
  def withStorageClassName(value: String) : PersistentVolumeSpec = copy(storageClassName = Some(value))
  /** if storageClassName has a value, transforms to the result of function*/
  def mapStorageClassName(f: String => String) : PersistentVolumeSpec = copy(storageClassName = storageClassName.map(f))

  /** Returns a new data with photonPersistentDisk set to new value */
  def withPhotonPersistentDisk(value: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(photonPersistentDisk = Some(value))
  /** if photonPersistentDisk has a value, transforms to the result of function*/
  def mapPhotonPersistentDisk(f: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource => io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(photonPersistentDisk = photonPersistentDisk.map(f))

  /** Returns a new data with gcePersistentDisk set to new value */
  def withGcePersistentDisk(value: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(gcePersistentDisk = Some(value))
  /** if gcePersistentDisk has a value, transforms to the result of function*/
  def mapGcePersistentDisk(f: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource => io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : PersistentVolumeSpec = copy(gcePersistentDisk = gcePersistentDisk.map(f))

  /** Returns a new data with vsphereVolume set to new value */
  def withVsphereVolume(value: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : PersistentVolumeSpec = copy(vsphereVolume = Some(value))
  /** if vsphereVolume has a value, transforms to the result of function*/
  def mapVsphereVolume(f: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource => io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : PersistentVolumeSpec = copy(vsphereVolume = vsphereVolume.map(f))

  /** Returns a new data with iscsi set to new value */
  def withIscsi(value: io.k8s.api.core.v1.ISCSIPersistentVolumeSource) : PersistentVolumeSpec = copy(iscsi = Some(value))
  /** if iscsi has a value, transforms to the result of function*/
  def mapIscsi(f: io.k8s.api.core.v1.ISCSIPersistentVolumeSource => io.k8s.api.core.v1.ISCSIPersistentVolumeSource) : PersistentVolumeSpec = copy(iscsi = iscsi.map(f))

  /** Returns a new data with cinder set to new value */
  def withCinder(value: io.k8s.api.core.v1.CinderPersistentVolumeSource) : PersistentVolumeSpec = copy(cinder = Some(value))
  /** if cinder has a value, transforms to the result of function*/
  def mapCinder(f: io.k8s.api.core.v1.CinderPersistentVolumeSource => io.k8s.api.core.v1.CinderPersistentVolumeSource) : PersistentVolumeSpec = copy(cinder = cinder.map(f))

  /** Returns a new data with cephfs set to new value */
  def withCephfs(value: io.k8s.api.core.v1.CephFSPersistentVolumeSource) : PersistentVolumeSpec = copy(cephfs = Some(value))
  /** if cephfs has a value, transforms to the result of function*/
  def mapCephfs(f: io.k8s.api.core.v1.CephFSPersistentVolumeSource => io.k8s.api.core.v1.CephFSPersistentVolumeSource) : PersistentVolumeSpec = copy(cephfs = cephfs.map(f))

  /** Returns a new data with awsElasticBlockStore set to new value */
  def withAwsElasticBlockStore(value: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : PersistentVolumeSpec = copy(awsElasticBlockStore = Some(value))
  /** if awsElasticBlockStore has a value, transforms to the result of function*/
  def mapAwsElasticBlockStore(f: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource => io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : PersistentVolumeSpec = copy(awsElasticBlockStore = awsElasticBlockStore.map(f))

  /** Returns a new data with flexVolume set to new value */
  def withFlexVolume(value: io.k8s.api.core.v1.FlexPersistentVolumeSource) : PersistentVolumeSpec = copy(flexVolume = Some(value))
  /** if flexVolume has a value, transforms to the result of function*/
  def mapFlexVolume(f: io.k8s.api.core.v1.FlexPersistentVolumeSource => io.k8s.api.core.v1.FlexPersistentVolumeSource) : PersistentVolumeSpec = copy(flexVolume = flexVolume.map(f))

  /** Returns a new data with nfs set to new value */
  def withNfs(value: io.k8s.api.core.v1.NFSVolumeSource) : PersistentVolumeSpec = copy(nfs = Some(value))
  /** if nfs has a value, transforms to the result of function*/
  def mapNfs(f: io.k8s.api.core.v1.NFSVolumeSource => io.k8s.api.core.v1.NFSVolumeSource) : PersistentVolumeSpec = copy(nfs = nfs.map(f))

  /** Returns a new data with quobyte set to new value */
  def withQuobyte(value: io.k8s.api.core.v1.QuobyteVolumeSource) : PersistentVolumeSpec = copy(quobyte = Some(value))
  /** if quobyte has a value, transforms to the result of function*/
  def mapQuobyte(f: io.k8s.api.core.v1.QuobyteVolumeSource => io.k8s.api.core.v1.QuobyteVolumeSource) : PersistentVolumeSpec = copy(quobyte = quobyte.map(f))

  /** Returns a new data with storageos set to new value */
  def withStorageos(value: io.k8s.api.core.v1.StorageOSPersistentVolumeSource) : PersistentVolumeSpec = copy(storageos = Some(value))
  /** if storageos has a value, transforms to the result of function*/
  def mapStorageos(f: io.k8s.api.core.v1.StorageOSPersistentVolumeSource => io.k8s.api.core.v1.StorageOSPersistentVolumeSource) : PersistentVolumeSpec = copy(storageos = storageos.map(f))

  /** Returns a new data with capacity set to new value */
  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeSpec = copy(capacity = Some(value))
  /** Adds new values to capacity */
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeSpec = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))
  /** if capacity has a value, transforms to the result of function*/
  def mapCapacity(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeSpec = copy(capacity = capacity.map(f))
}

object PersistentVolumeSpec {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PersistentVolumeSpec] = new Encoder[io.k8s.api.core.v1.PersistentVolumeSpec] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PersistentVolumeSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("scaleIO", o.scaleIO)
            .write("csi", o.csi)
            .write("accessModes", o.accessModes)
            .write("mountOptions", o.mountOptions)
            .write("nodeAffinity", o.nodeAffinity)
            .write("azureDisk", o.azureDisk)
            .write("azureFile", o.azureFile)
            .write("hostPath", o.hostPath)
            .write("rbd", o.rbd)
            .write("portworxVolume", o.portworxVolume)
            .write("persistentVolumeReclaimPolicy", o.persistentVolumeReclaimPolicy)
            .write("glusterfs", o.glusterfs)
            .write("volumeMode", o.volumeMode)
            .write("flocker", o.flocker)
            .write("claimRef", o.claimRef)
            .write("fc", o.fc)
            .write("local", o.local)
            .write("storageClassName", o.storageClassName)
            .write("photonPersistentDisk", o.photonPersistentDisk)
            .write("gcePersistentDisk", o.gcePersistentDisk)
            .write("vsphereVolume", o.vsphereVolume)
            .write("iscsi", o.iscsi)
            .write("cinder", o.cinder)
            .write("cephfs", o.cephfs)
            .write("awsElasticBlockStore", o.awsElasticBlockStore)
            .write("flexVolume", o.flexVolume)
            .write("nfs", o.nfs)
            .write("quobyte", o.quobyte)
            .write("storageos", o.storageos)
            .write("capacity", o.capacity)
            .build
        }
    }

    implicit val decoder: Decoder[PersistentVolumeSpec] = new Decoder[PersistentVolumeSpec] {
      def apply[T : Reader](t: T): Either[String, PersistentVolumeSpec] = for {
          obj <- ObjectReader(t)
          scaleIO <- obj.readOpt[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource]("scaleIO")
          csi <- obj.readOpt[io.k8s.api.core.v1.CSIPersistentVolumeSource]("csi")
          accessModes <- obj.readOpt[Seq[String]]("accessModes")
          mountOptions <- obj.readOpt[Seq[String]]("mountOptions")
          nodeAffinity <- obj.readOpt[io.k8s.api.core.v1.VolumeNodeAffinity]("nodeAffinity")
          azureDisk <- obj.readOpt[io.k8s.api.core.v1.AzureDiskVolumeSource]("azureDisk")
          azureFile <- obj.readOpt[io.k8s.api.core.v1.AzureFilePersistentVolumeSource]("azureFile")
          hostPath <- obj.readOpt[io.k8s.api.core.v1.HostPathVolumeSource]("hostPath")
          rbd <- obj.readOpt[io.k8s.api.core.v1.RBDPersistentVolumeSource]("rbd")
          portworxVolume <- obj.readOpt[io.k8s.api.core.v1.PortworxVolumeSource]("portworxVolume")
          persistentVolumeReclaimPolicy <- obj.readOpt[String]("persistentVolumeReclaimPolicy")
          glusterfs <- obj.readOpt[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource]("glusterfs")
          volumeMode <- obj.readOpt[String]("volumeMode")
          flocker <- obj.readOpt[io.k8s.api.core.v1.FlockerVolumeSource]("flocker")
          claimRef <- obj.readOpt[io.k8s.api.core.v1.ObjectReference]("claimRef")
          fc <- obj.readOpt[io.k8s.api.core.v1.FCVolumeSource]("fc")
          local <- obj.readOpt[io.k8s.api.core.v1.LocalVolumeSource]("local")
          storageClassName <- obj.readOpt[String]("storageClassName")
          photonPersistentDisk <- obj.readOpt[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]("photonPersistentDisk")
          gcePersistentDisk <- obj.readOpt[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]("gcePersistentDisk")
          vsphereVolume <- obj.readOpt[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]("vsphereVolume")
          iscsi <- obj.readOpt[io.k8s.api.core.v1.ISCSIPersistentVolumeSource]("iscsi")
          cinder <- obj.readOpt[io.k8s.api.core.v1.CinderPersistentVolumeSource]("cinder")
          cephfs <- obj.readOpt[io.k8s.api.core.v1.CephFSPersistentVolumeSource]("cephfs")
          awsElasticBlockStore <- obj.readOpt[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]("awsElasticBlockStore")
          flexVolume <- obj.readOpt[io.k8s.api.core.v1.FlexPersistentVolumeSource]("flexVolume")
          nfs <- obj.readOpt[io.k8s.api.core.v1.NFSVolumeSource]("nfs")
          quobyte <- obj.readOpt[io.k8s.api.core.v1.QuobyteVolumeSource]("quobyte")
          storageos <- obj.readOpt[io.k8s.api.core.v1.StorageOSPersistentVolumeSource]("storageos")
          capacity <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("capacity")
      } yield PersistentVolumeSpec (
          scaleIO = scaleIO,
          csi = csi,
          accessModes = accessModes,
          mountOptions = mountOptions,
          nodeAffinity = nodeAffinity,
          azureDisk = azureDisk,
          azureFile = azureFile,
          hostPath = hostPath,
          rbd = rbd,
          portworxVolume = portworxVolume,
          persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy,
          glusterfs = glusterfs,
          volumeMode = volumeMode,
          flocker = flocker,
          claimRef = claimRef,
          fc = fc,
          local = local,
          storageClassName = storageClassName,
          photonPersistentDisk = photonPersistentDisk,
          gcePersistentDisk = gcePersistentDisk,
          vsphereVolume = vsphereVolume,
          iscsi = iscsi,
          cinder = cinder,
          cephfs = cephfs,
          awsElasticBlockStore = awsElasticBlockStore,
          flexVolume = flexVolume,
          nfs = nfs,
          quobyte = quobyte,
          storageos = storageos,
          capacity = capacity
        )
    }
}

