package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** MutatingWebhook describes an admission webhook and the resources and operations it applies to. */
final case class MutatingWebhook(
  name : String,
  sideEffects : String,
  clientConfig : io.k8s.api.admissionregistration.v1.WebhookClientConfig,
  admissionReviewVersions : Seq[String],
  timeoutSeconds : Option[Int] = None,
  matchPolicy : Option[String] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  failurePolicy : Option[String] = None,
  reinvocationPolicy : Option[String] = None,
  rules : Option[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]] = None,
  objectSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : MutatingWebhook = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : MutatingWebhook = copy(name = f(name))

  /** Returns a new data with sideEffects set to new value */
  def withSideEffects(value: String) : MutatingWebhook = copy(sideEffects = value)
  /** transforms sideEffects to result of function */
  def mapSideEffects(f: String => String) : MutatingWebhook = copy(sideEffects = f(sideEffects))

  /** Returns a new data with clientConfig set to new value */
  def withClientConfig(value: io.k8s.api.admissionregistration.v1.WebhookClientConfig) : MutatingWebhook = copy(clientConfig = value)
  /** transforms clientConfig to result of function */
  def mapClientConfig(f: io.k8s.api.admissionregistration.v1.WebhookClientConfig => io.k8s.api.admissionregistration.v1.WebhookClientConfig) : MutatingWebhook = copy(clientConfig = f(clientConfig))

  /** Returns a new data with admissionReviewVersions set to new value */
  def withAdmissionReviewVersions(value: Seq[String]) : MutatingWebhook = copy(admissionReviewVersions = value)
  /** Appends new values to admissionReviewVersions */
  def addAdmissionReviewVersions(newValues: String*) : MutatingWebhook = copy(admissionReviewVersions = admissionReviewVersions ++ newValues)
  /** transforms admissionReviewVersions to result of function */
  def mapAdmissionReviewVersions(f: Seq[String] => Seq[String]) : MutatingWebhook = copy(admissionReviewVersions = f(admissionReviewVersions))

  /** Returns a new data with timeoutSeconds set to new value */
  def withTimeoutSeconds(value: Int) : MutatingWebhook = copy(timeoutSeconds = Some(value))
  /** if timeoutSeconds has a value, transforms to the result of function*/
  def mapTimeoutSeconds(f: Int => Int) : MutatingWebhook = copy(timeoutSeconds = timeoutSeconds.map(f))

  /** Returns a new data with matchPolicy set to new value */
  def withMatchPolicy(value: String) : MutatingWebhook = copy(matchPolicy = Some(value))
  /** if matchPolicy has a value, transforms to the result of function*/
  def mapMatchPolicy(f: String => String) : MutatingWebhook = copy(matchPolicy = matchPolicy.map(f))

  /** Returns a new data with namespaceSelector set to new value */
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(namespaceSelector = Some(value))
  /** if namespaceSelector has a value, transforms to the result of function*/
  def mapNamespaceSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(namespaceSelector = namespaceSelector.map(f))

  /** Returns a new data with failurePolicy set to new value */
  def withFailurePolicy(value: String) : MutatingWebhook = copy(failurePolicy = Some(value))
  /** if failurePolicy has a value, transforms to the result of function*/
  def mapFailurePolicy(f: String => String) : MutatingWebhook = copy(failurePolicy = failurePolicy.map(f))

  /** Returns a new data with reinvocationPolicy set to new value */
  def withReinvocationPolicy(value: String) : MutatingWebhook = copy(reinvocationPolicy = Some(value))
  /** if reinvocationPolicy has a value, transforms to the result of function*/
  def mapReinvocationPolicy(f: String => String) : MutatingWebhook = copy(reinvocationPolicy = reinvocationPolicy.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]) : MutatingWebhook = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.admissionregistration.v1.RuleWithOperations*) : MutatingWebhook = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations] => Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]) : MutatingWebhook = copy(rules = rules.map(f))

  /** Returns a new data with objectSelector set to new value */
  def withObjectSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(objectSelector = Some(value))
  /** if objectSelector has a value, transforms to the result of function*/
  def mapObjectSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MutatingWebhook = copy(objectSelector = objectSelector.map(f))
}

object MutatingWebhook {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhook] = new Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhook] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.MutatingWebhook) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("sideEffects", o.sideEffects)
            .write("clientConfig", o.clientConfig)
            .write("admissionReviewVersions", o.admissionReviewVersions)
            .write("timeoutSeconds", o.timeoutSeconds)
            .write("matchPolicy", o.matchPolicy)
            .write("namespaceSelector", o.namespaceSelector)
            .write("failurePolicy", o.failurePolicy)
            .write("reinvocationPolicy", o.reinvocationPolicy)
            .write("rules", o.rules)
            .write("objectSelector", o.objectSelector)
            .build
        }
    }

    implicit val decoder: Decoder[MutatingWebhook] = new Decoder[MutatingWebhook] {
      def apply[T : Reader](t: T): Either[String, MutatingWebhook] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          sideEffects <- obj.read[String]("sideEffects")
          clientConfig <- obj.read[io.k8s.api.admissionregistration.v1.WebhookClientConfig]("clientConfig")
          admissionReviewVersions <- obj.read[Seq[String]]("admissionReviewVersions")
          timeoutSeconds <- obj.readOpt[Int]("timeoutSeconds")
          matchPolicy <- obj.readOpt[String]("matchPolicy")
          namespaceSelector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("namespaceSelector")
          failurePolicy <- obj.readOpt[String]("failurePolicy")
          reinvocationPolicy <- obj.readOpt[String]("reinvocationPolicy")
          rules <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]]("rules")
          objectSelector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("objectSelector")
      } yield MutatingWebhook (
          name = name,
          sideEffects = sideEffects,
          clientConfig = clientConfig,
          admissionReviewVersions = admissionReviewVersions,
          timeoutSeconds = timeoutSeconds,
          matchPolicy = matchPolicy,
          namespaceSelector = namespaceSelector,
          failurePolicy = failurePolicy,
          reinvocationPolicy = reinvocationPolicy,
          rules = rules,
          objectSelector = objectSelector
        )
    }
}

