package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s.utils._

/** Spec of the storage version migration. */
final case class StorageVersionMigrationSpec(
  resource : io.k8s.api.storagemigration.v1alpha1.GroupVersionResource,
  continueToken : Option[String] = None
) {

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.storagemigration.v1alpha1.GroupVersionResource) : StorageVersionMigrationSpec = copy(resource = value)
  /** transforms resource to result of function */
  def mapResource(f: io.k8s.api.storagemigration.v1alpha1.GroupVersionResource => io.k8s.api.storagemigration.v1alpha1.GroupVersionResource) : StorageVersionMigrationSpec = copy(resource = f(resource))

  /** Returns a new data with continueToken set to new value */
  def withContinueToken(value: String) : StorageVersionMigrationSpec = copy(continueToken = Some(value))
  /** if continueToken has a value, transforms to the result of function*/
  def mapContinueToken(f: String => String) : StorageVersionMigrationSpec = copy(continueToken = continueToken.map(f))
}

object StorageVersionMigrationSpec {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec] = new Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resource", o.resource)
            .write("continueToken", o.continueToken)
            .build
        }
    }

    implicit val decoder: Decoder[StorageVersionMigrationSpec] = new Decoder[StorageVersionMigrationSpec] {
      def apply[T : Reader](t: T): Either[String, StorageVersionMigrationSpec] = for {
          obj <- ObjectReader(t)
          resource <- obj.read[io.k8s.api.storagemigration.v1alpha1.GroupVersionResource]("resource")
          continueToken <- obj.readOpt[String]("continueToken")
      } yield StorageVersionMigrationSpec (
          resource = resource,
          continueToken = continueToken
        )
    }
}

