package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** StructuredResourceHandle is the in-tree representation of the allocation result. */
final case class StructuredResourceHandle(
  results : Seq[io.k8s.api.resource.v1alpha2.DriverAllocationResult],
  nodeName : Option[String] = None,
  vendorClaimParameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None,
  vendorClassParameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None
) {

  /** Returns a new data with results set to new value */
  def withResults(value: Seq[io.k8s.api.resource.v1alpha2.DriverAllocationResult]) : StructuredResourceHandle = copy(results = value)
  /** Appends new values to results */
  def addResults(newValues: io.k8s.api.resource.v1alpha2.DriverAllocationResult*) : StructuredResourceHandle = copy(results = results ++ newValues)
  /** transforms results to result of function */
  def mapResults(f: Seq[io.k8s.api.resource.v1alpha2.DriverAllocationResult] => Seq[io.k8s.api.resource.v1alpha2.DriverAllocationResult]) : StructuredResourceHandle = copy(results = f(results))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : StructuredResourceHandle = copy(nodeName = Some(value))
  /** if nodeName has a value, transforms to the result of function*/
  def mapNodeName(f: String => String) : StructuredResourceHandle = copy(nodeName = nodeName.map(f))

  /** Returns a new data with vendorClaimParameters set to new value */
  def withVendorClaimParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : StructuredResourceHandle = copy(vendorClaimParameters = Some(value))
  /** if vendorClaimParameters has a value, transforms to the result of function*/
  def mapVendorClaimParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : StructuredResourceHandle = copy(vendorClaimParameters = vendorClaimParameters.map(f))

  /** Returns a new data with vendorClassParameters set to new value */
  def withVendorClassParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : StructuredResourceHandle = copy(vendorClassParameters = Some(value))
  /** if vendorClassParameters has a value, transforms to the result of function*/
  def mapVendorClassParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : StructuredResourceHandle = copy(vendorClassParameters = vendorClassParameters.map(f))
}

object StructuredResourceHandle {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.StructuredResourceHandle] = new Encoder[io.k8s.api.resource.v1alpha2.StructuredResourceHandle] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.StructuredResourceHandle) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("results", o.results)
            .write("nodeName", o.nodeName)
            .write("vendorClaimParameters", o.vendorClaimParameters)
            .write("vendorClassParameters", o.vendorClassParameters)
            .build
        }
    }

    implicit val decoder: Decoder[StructuredResourceHandle] = new Decoder[StructuredResourceHandle] {
      def apply[T : Reader](t: T): Either[String, StructuredResourceHandle] = for {
          obj <- ObjectReader(t)
          results <- obj.read[Seq[io.k8s.api.resource.v1alpha2.DriverAllocationResult]]("results")
          nodeName <- obj.readOpt[String]("nodeName")
          vendorClaimParameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("vendorClaimParameters")
          vendorClassParameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("vendorClassParameters")
      } yield StructuredResourceHandle (
          results = results,
          nodeName = nodeName,
          vendorClaimParameters = vendorClaimParameters,
          vendorClassParameters = vendorClassParameters
        )
    }
}

