package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are. */
final case class ResourceClaimStatus(
  allocation : Option[io.k8s.api.resource.v1alpha2.AllocationResult] = None,
  deallocationRequested : Option[Boolean] = None,
  driverName : Option[String] = None,
  reservedFor : Option[Seq[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference]] = None
) {

  /** Returns a new data with allocation set to new value */
  def withAllocation(value: io.k8s.api.resource.v1alpha2.AllocationResult) : ResourceClaimStatus = copy(allocation = Some(value))
  /** if allocation has a value, transforms to the result of function*/
  def mapAllocation(f: io.k8s.api.resource.v1alpha2.AllocationResult => io.k8s.api.resource.v1alpha2.AllocationResult) : ResourceClaimStatus = copy(allocation = allocation.map(f))

  /** Returns a new data with deallocationRequested set to new value */
  def withDeallocationRequested(value: Boolean) : ResourceClaimStatus = copy(deallocationRequested = Some(value))
  /** if deallocationRequested has a value, transforms to the result of function*/
  def mapDeallocationRequested(f: Boolean => Boolean) : ResourceClaimStatus = copy(deallocationRequested = deallocationRequested.map(f))

  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : ResourceClaimStatus = copy(driverName = Some(value))
  /** if driverName has a value, transforms to the result of function*/
  def mapDriverName(f: String => String) : ResourceClaimStatus = copy(driverName = driverName.map(f))

  /** Returns a new data with reservedFor set to new value */
  def withReservedFor(value: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference]) : ResourceClaimStatus = copy(reservedFor = Some(value))
  /** Appends new values to reservedFor */
  def addReservedFor(newValues: io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference*) : ResourceClaimStatus = copy(reservedFor = Some(reservedFor.fold(newValues)(_ ++ newValues)))
  /** if reservedFor has a value, transforms to the result of function*/
  def mapReservedFor(f: Seq[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference] => Seq[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference]) : ResourceClaimStatus = copy(reservedFor = reservedFor.map(f))
}

object ResourceClaimStatus {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimStatus] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimStatus] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("allocation", o.allocation)
            .write("deallocationRequested", o.deallocationRequested)
            .write("driverName", o.driverName)
            .write("reservedFor", o.reservedFor)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimStatus] = new Decoder[ResourceClaimStatus] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimStatus] = for {
          obj <- ObjectReader(t)
          allocation <- obj.readOpt[io.k8s.api.resource.v1alpha2.AllocationResult]("allocation")
          deallocationRequested <- obj.readOpt[Boolean]("deallocationRequested")
          driverName <- obj.readOpt[String]("driverName")
          reservedFor <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference]]("reservedFor")
      } yield ResourceClaimStatus (
          allocation = allocation,
          deallocationRequested = deallocationRequested,
          driverName = driverName,
          reservedFor = reservedFor
        )
    }
}

