package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressLoadBalancerIngress represents the status of a load-balancer ingress point. */
final case class IngressLoadBalancerIngress(
  hostname : Option[String] = None,
  ip : Option[String] = None,
  ports : Option[Seq[io.k8s.api.networking.v1.IngressPortStatus]] = None
) {

  /** Returns a new data with hostname set to new value */
  def withHostname(value: String) : IngressLoadBalancerIngress = copy(hostname = Some(value))
  /** if hostname has a value, transforms to the result of function*/
  def mapHostname(f: String => String) : IngressLoadBalancerIngress = copy(hostname = hostname.map(f))

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : IngressLoadBalancerIngress = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : IngressLoadBalancerIngress = copy(ip = ip.map(f))

  /** Returns a new data with ports set to new value */
  def withPorts(value: Seq[io.k8s.api.networking.v1.IngressPortStatus]) : IngressLoadBalancerIngress = copy(ports = Some(value))
  /** Appends new values to ports */
  def addPorts(newValues: io.k8s.api.networking.v1.IngressPortStatus*) : IngressLoadBalancerIngress = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))
  /** if ports has a value, transforms to the result of function*/
  def mapPorts(f: Seq[io.k8s.api.networking.v1.IngressPortStatus] => Seq[io.k8s.api.networking.v1.IngressPortStatus]) : IngressLoadBalancerIngress = copy(ports = ports.map(f))
}

object IngressLoadBalancerIngress {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressLoadBalancerIngress] = new Encoder[io.k8s.api.networking.v1.IngressLoadBalancerIngress] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressLoadBalancerIngress) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("hostname", o.hostname)
            .write("ip", o.ip)
            .write("ports", o.ports)
            .build
        }
    }

    implicit val decoder: Decoder[IngressLoadBalancerIngress] = new Decoder[IngressLoadBalancerIngress] {
      def apply[T : Reader](t: T): Either[String, IngressLoadBalancerIngress] = for {
          obj <- ObjectReader(t)
          hostname <- obj.readOpt[String]("hostname")
          ip <- obj.readOpt[String]("ip")
          ports <- obj.readOpt[Seq[io.k8s.api.networking.v1.IngressPortStatus]]("ports")
      } yield IngressLoadBalancerIngress (
          hostname = hostname,
          ip = ip,
          ports = ports
        )
    }
}

