package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm. */
final case class NodeSelectorTerm(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None,
  matchFields : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None
) {

  /** Returns a new data with matchExpressions set to new value */
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchExpressions = Some(value))
  /** Appends new values to matchExpressions */
  def addMatchExpressions(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchExpressions has a value, transforms to the result of function*/
  def mapMatchExpressions(f: Seq[io.k8s.api.core.v1.NodeSelectorRequirement] => Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchExpressions = matchExpressions.map(f))

  /** Returns a new data with matchFields set to new value */
  def withMatchFields(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchFields = Some(value))
  /** Appends new values to matchFields */
  def addMatchFields(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchFields = Some(matchFields.fold(newValues)(_ ++ newValues)))
  /** if matchFields has a value, transforms to the result of function*/
  def mapMatchFields(f: Seq[io.k8s.api.core.v1.NodeSelectorRequirement] => Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchFields = matchFields.map(f))
}

object NodeSelectorTerm {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeSelectorTerm] = new Encoder[io.k8s.api.core.v1.NodeSelectorTerm] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeSelectorTerm) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchExpressions", o.matchExpressions)
            .write("matchFields", o.matchFields)
            .build
        }
    }

    implicit val decoder: Decoder[NodeSelectorTerm] = new Decoder[NodeSelectorTerm] {
      def apply[T : Reader](t: T): Either[String, NodeSelectorTerm] = for {
          obj <- ObjectReader(t)
          matchExpressions <- obj.readOpt[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]]("matchExpressions")
          matchFields <- obj.readOpt[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]]("matchFields")
      } yield NodeSelectorTerm (
          matchExpressions = matchExpressions,
          matchFields = matchFields
        )
    }
}

