package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** ParamKind is a tuple of Group Kind and Version. */
final case class ParamKind(
  apiVersion : Option[String] = None,
  kind : Option[String] = None
) {

  /** Returns a new data with apiVersion set to new value */
  def withApiVersion(value: String) : ParamKind = copy(apiVersion = Some(value))
  /** if apiVersion has a value, transforms to the result of function*/
  def mapApiVersion(f: String => String) : ParamKind = copy(apiVersion = apiVersion.map(f))

  /** Returns a new data with kind set to new value */
  def withKind(value: String) : ParamKind = copy(kind = Some(value))
  /** if kind has a value, transforms to the result of function*/
  def mapKind(f: String => String) : ParamKind = copy(kind = kind.map(f))
}

object ParamKind {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.ParamKind] = new Encoder[io.k8s.api.admissionregistration.v1.ParamKind] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.ParamKind) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("apiVersion", o.apiVersion)
            .write("kind", o.kind)
            .build
        }
    }

    implicit val decoder: Decoder[ParamKind] = new Decoder[ParamKind] {
      def apply[T : Reader](t: T): Either[String, ParamKind] = for {
          obj <- ObjectReader(t)
          apiVersion <- obj.readOpt[String]("apiVersion")
          kind <- obj.readOpt[String]("kind")
      } yield ParamKind (
          apiVersion = apiVersion,
          kind = kind
        )
    }
}

