package io.k8s.api.flowcontrol.v1

import dev.hnaderi.k8s.utils._

/** FlowSchemaSpec describes how the FlowSchema's specification looks like. */
final case class FlowSchemaSpec(
  priorityLevelConfiguration : io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference,
  distinguisherMethod : Option[io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod] = None,
  matchingPrecedence : Option[Int] = None,
  rules : Option[Seq[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects]] = None
) {

  /** Returns a new data with priorityLevelConfiguration set to new value */
  def withPriorityLevelConfiguration(value: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = value)
  /** transforms priorityLevelConfiguration to result of function */
  def mapPriorityLevelConfiguration(f: io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference => io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = f(priorityLevelConfiguration))

  /** Returns a new data with distinguisherMethod set to new value */
  def withDistinguisherMethod(value: io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = Some(value))
  /** if distinguisherMethod has a value, transforms to the result of function*/
  def mapDistinguisherMethod(f: io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod => io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = distinguisherMethod.map(f))

  /** Returns a new data with matchingPrecedence set to new value */
  def withMatchingPrecedence(value: Int) : FlowSchemaSpec = copy(matchingPrecedence = Some(value))
  /** if matchingPrecedence has a value, transforms to the result of function*/
  def mapMatchingPrecedence(f: Int => Int) : FlowSchemaSpec = copy(matchingPrecedence = matchingPrecedence.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects*) : FlowSchemaSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects] => Seq[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = rules.map(f))
}

object FlowSchemaSpec {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1.FlowSchemaSpec] = new Encoder[io.k8s.api.flowcontrol.v1.FlowSchemaSpec] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1.FlowSchemaSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("priorityLevelConfiguration", o.priorityLevelConfiguration)
            .write("distinguisherMethod", o.distinguisherMethod)
            .write("matchingPrecedence", o.matchingPrecedence)
            .write("rules", o.rules)
            .build
        }
    }

    implicit val decoder: Decoder[FlowSchemaSpec] = new Decoder[FlowSchemaSpec] {
      def apply[T : Reader](t: T): Either[String, FlowSchemaSpec] = for {
          obj <- ObjectReader(t)
          priorityLevelConfiguration <- obj.read[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference]("priorityLevelConfiguration")
          distinguisherMethod <- obj.readOpt[io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod]("distinguisherMethod")
          matchingPrecedence <- obj.readOpt[Int]("matchingPrecedence")
          rules <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects]]("rules")
      } yield FlowSchemaSpec (
          priorityLevelConfiguration = priorityLevelConfiguration,
          distinguisherMethod = distinguisherMethod,
          matchingPrecedence = matchingPrecedence,
          rules = rules
        )
    }
}

