package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. */
final case class ResourceMetricStatus(
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  name : String
) {

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : ResourceMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2.MetricValueStatus => io.k8s.api.autoscaling.v2.MetricValueStatus) : ResourceMetricStatus = copy(current = f(current))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceMetricStatus = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceMetricStatus = copy(name = f(name))
}

object ResourceMetricStatus {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2.ResourceMetricStatus] = new Encoder[io.k8s.api.autoscaling.v2.ResourceMetricStatus] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2.ResourceMetricStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("current", o.current)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceMetricStatus] = new Decoder[ResourceMetricStatus] {
      def apply[T : Reader](t: T): Either[String, ResourceMetricStatus] = for {
          obj <- ObjectReader(t)
          current <- obj.read[io.k8s.api.autoscaling.v2.MetricValueStatus]("current")
          name <- obj.read[String]("name")
      } yield ResourceMetricStatus (
          current = current,
          name = name
        )
    }
}

