package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified. */
final case class LifecycleHandler(
  exec : Option[io.k8s.api.core.v1.ExecAction] = None,
  httpGet : Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  sleep : Option[io.k8s.api.core.v1.SleepAction] = None,
  tcpSocket : Option[io.k8s.api.core.v1.TCPSocketAction] = None
) {

  /** Returns a new data with exec set to new value */
  def withExec(value: io.k8s.api.core.v1.ExecAction) : LifecycleHandler = copy(exec = Some(value))
  /** if exec has a value, transforms to the result of function*/
  def mapExec(f: io.k8s.api.core.v1.ExecAction => io.k8s.api.core.v1.ExecAction) : LifecycleHandler = copy(exec = exec.map(f))

  /** Returns a new data with httpGet set to new value */
  def withHttpGet(value: io.k8s.api.core.v1.HTTPGetAction) : LifecycleHandler = copy(httpGet = Some(value))
  /** if httpGet has a value, transforms to the result of function*/
  def mapHttpGet(f: io.k8s.api.core.v1.HTTPGetAction => io.k8s.api.core.v1.HTTPGetAction) : LifecycleHandler = copy(httpGet = httpGet.map(f))

  /** Returns a new data with sleep set to new value */
  def withSleep(value: io.k8s.api.core.v1.SleepAction) : LifecycleHandler = copy(sleep = Some(value))
  /** if sleep has a value, transforms to the result of function*/
  def mapSleep(f: io.k8s.api.core.v1.SleepAction => io.k8s.api.core.v1.SleepAction) : LifecycleHandler = copy(sleep = sleep.map(f))

  /** Returns a new data with tcpSocket set to new value */
  def withTcpSocket(value: io.k8s.api.core.v1.TCPSocketAction) : LifecycleHandler = copy(tcpSocket = Some(value))
  /** if tcpSocket has a value, transforms to the result of function*/
  def mapTcpSocket(f: io.k8s.api.core.v1.TCPSocketAction => io.k8s.api.core.v1.TCPSocketAction) : LifecycleHandler = copy(tcpSocket = tcpSocket.map(f))
}

object LifecycleHandler {

    implicit val encoder : Encoder[io.k8s.api.core.v1.LifecycleHandler] = new Encoder[io.k8s.api.core.v1.LifecycleHandler] {
        def apply[T : Builder](o: io.k8s.api.core.v1.LifecycleHandler) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("exec", o.exec)
            .write("httpGet", o.httpGet)
            .write("sleep", o.sleep)
            .write("tcpSocket", o.tcpSocket)
            .build
        }
    }

    implicit val decoder: Decoder[LifecycleHandler] = new Decoder[LifecycleHandler] {
      def apply[T : Reader](t: T): Either[String, LifecycleHandler] = for {
          obj <- ObjectReader(t)
          exec <- obj.readOpt[io.k8s.api.core.v1.ExecAction]("exec")
          httpGet <- obj.readOpt[io.k8s.api.core.v1.HTTPGetAction]("httpGet")
          sleep <- obj.readOpt[io.k8s.api.core.v1.SleepAction]("sleep")
          tcpSocket <- obj.readOpt[io.k8s.api.core.v1.TCPSocketAction]("tcpSocket")
      } yield LifecycleHandler (
          exec = exec,
          httpGet = httpGet,
          sleep = sleep,
          tcpSocket = tcpSocket
        )
    }
}

