package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClass is used by administrators to influence how resources are allocated.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class ResourceClass(
  driverName : String,
  suitableNodes : Option[io.k8s.api.core.v1.NodeSelector] = None,
  parametersRef : Option[io.k8s.api.resource.v1alpha2.ResourceClassParametersReference] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClass", "v1alpha2")


  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : ResourceClass = copy(driverName = value)
  /** transforms driverName to result of function */
  def mapDriverName(f: String => String) : ResourceClass = copy(driverName = f(driverName))

  /** Returns a new data with suitableNodes set to new value */
  def withSuitableNodes(value: io.k8s.api.core.v1.NodeSelector) : ResourceClass = copy(suitableNodes = Some(value))
  /** if suitableNodes has a value, transforms to the result of function*/
  def mapSuitableNodes(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : ResourceClass = copy(suitableNodes = suitableNodes.map(f))

  /** Returns a new data with parametersRef set to new value */
  def withParametersRef(value: io.k8s.api.resource.v1alpha2.ResourceClassParametersReference) : ResourceClass = copy(parametersRef = Some(value))
  /** if parametersRef has a value, transforms to the result of function*/
  def mapParametersRef(f: io.k8s.api.resource.v1alpha2.ResourceClassParametersReference => io.k8s.api.resource.v1alpha2.ResourceClassParametersReference) : ResourceClass = copy(parametersRef = parametersRef.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClass = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClass = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClass.encoder.apply(this)
}

object ResourceClass {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClass] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClass] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClass) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("suitableNodes", o.suitableNodes)
            .write("parametersRef", o.parametersRef)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClass] = new Decoder[ResourceClass] {
      def apply[T : Reader](t: T): Either[String, ResourceClass] = for {
          obj <- ObjectReader(t)
          driverName <- obj.read[String]("driverName")
          suitableNodes <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("suitableNodes")
          parametersRef <- obj.readOpt[io.k8s.api.resource.v1alpha2.ResourceClassParametersReference]("parametersRef")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceClass (
          driverName = driverName,
          suitableNodes = suitableNodes,
          parametersRef = parametersRef,
          metadata = metadata
        )
    }
}

