package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** DaemonSetSpec is the specification of a daemon set. */
final case class DaemonSetSpec(
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  minReadySeconds : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  updateStrategy : Option[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = None
) {

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : DaemonSetSpec = copy(template = value)
  /** transforms template to result of function */
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : DaemonSetSpec = copy(template = f(template))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DaemonSetSpec = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DaemonSetSpec = copy(selector = f(selector))

  /** Returns a new data with minReadySeconds set to new value */
  def withMinReadySeconds(value: Int) : DaemonSetSpec = copy(minReadySeconds = Some(value))
  /** if minReadySeconds has a value, transforms to the result of function*/
  def mapMinReadySeconds(f: Int => Int) : DaemonSetSpec = copy(minReadySeconds = minReadySeconds.map(f))

  /** Returns a new data with revisionHistoryLimit set to new value */
  def withRevisionHistoryLimit(value: Int) : DaemonSetSpec = copy(revisionHistoryLimit = Some(value))
  /** if revisionHistoryLimit has a value, transforms to the result of function*/
  def mapRevisionHistoryLimit(f: Int => Int) : DaemonSetSpec = copy(revisionHistoryLimit = revisionHistoryLimit.map(f))

  /** Returns a new data with updateStrategy set to new value */
  def withUpdateStrategy(value: io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : DaemonSetSpec = copy(updateStrategy = Some(value))
  /** if updateStrategy has a value, transforms to the result of function*/
  def mapUpdateStrategy(f: io.k8s.api.apps.v1.DaemonSetUpdateStrategy => io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : DaemonSetSpec = copy(updateStrategy = updateStrategy.map(f))
}

object DaemonSetSpec {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.DaemonSetSpec] = new Encoder[io.k8s.api.apps.v1.DaemonSetSpec] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.DaemonSetSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("template", o.template)
            .write("selector", o.selector)
            .write("minReadySeconds", o.minReadySeconds)
            .write("revisionHistoryLimit", o.revisionHistoryLimit)
            .write("updateStrategy", o.updateStrategy)
            .build
        }
    }

    implicit val decoder: Decoder[DaemonSetSpec] = new Decoder[DaemonSetSpec] {
      def apply[T : Reader](t: T): Either[String, DaemonSetSpec] = for {
          obj <- ObjectReader(t)
          template <- obj.read[io.k8s.api.core.v1.PodTemplateSpec]("template")
          selector <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
          minReadySeconds <- obj.readOpt[Int]("minReadySeconds")
          revisionHistoryLimit <- obj.readOpt[Int]("revisionHistoryLimit")
          updateStrategy <- obj.readOpt[io.k8s.api.apps.v1.DaemonSetUpdateStrategy]("updateStrategy")
      } yield DaemonSetSpec (
          template = template,
          selector = selector,
          minReadySeconds = minReadySeconds,
          revisionHistoryLimit = revisionHistoryLimit,
          updateStrategy = updateStrategy
        )
    }
}

