package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** HostIP represents a single IP address allocated to the host. */
final case class HostIP(
  ip : Option[String] = None
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : HostIP = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : HostIP = copy(ip = ip.map(f))
}

object HostIP {

    implicit val encoder : Encoder[io.k8s.api.core.v1.HostIP] = new Encoder[io.k8s.api.core.v1.HostIP] {
        def apply[T : Builder](o: io.k8s.api.core.v1.HostIP) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ip", o.ip)
            .build
        }
    }

    implicit val decoder: Decoder[HostIP] = new Decoder[HostIP] {
      def apply[T : Reader](t: T): Either[String, HostIP] = for {
          obj <- ObjectReader(t)
          ip <- obj.readOpt[String]("ip")
      } yield HostIP (
          ip = ip
        )
    }
}

