package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers. */
final case class ControllerRevision(
  revision : Long,
  data : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ControllerRevision", "v1")


  /** Returns a new data with revision set to new value */
  def withRevision(value: Long) : ControllerRevision = copy(revision = value)
  /** transforms revision to result of function */
  def mapRevision(f: Long => Long) : ControllerRevision = copy(revision = f(revision))

  /** Returns a new data with data set to new value */
  def withData(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : ControllerRevision = copy(data = Some(value))
  /** if data has a value, transforms to the result of function*/
  def mapData(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : ControllerRevision = copy(data = data.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ControllerRevision = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ControllerRevision = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ControllerRevision.encoder.apply(this)
}

object ControllerRevision {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.ControllerRevision] = new Encoder[io.k8s.api.apps.v1.ControllerRevision] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.ControllerRevision) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("revision", o.revision)
            .write("data", o.data)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ControllerRevision] = new Decoder[ControllerRevision] {
      def apply[T : Reader](t: T): Either[String, ControllerRevision] = for {
          obj <- ObjectReader(t)
          revision <- obj.read[Long]("revision")
          data <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("data")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ControllerRevision (
          revision = revision,
          data = data,
          metadata = metadata
        )
    }
}

