package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** ServiceReference holds a reference to Service.legacy.k8s.io */
final case class ServiceReference(
  name : Option[String] = None,
  namespace : Option[String] = None,
  port : Option[Int] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ServiceReference = copy(name = name.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ServiceReference = copy(namespace = namespace.map(f))

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : ServiceReference = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: Int => Int) : ServiceReference = copy(port = port.map(f))
}

