package io.k8s.apimachinery.pkg.apis.meta.v1


/** StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined. */
final case class StatusDetails(
  name : Option[String] = None,
  causes : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]] = None,
  uid : Option[String] = None,
  retryAfterSeconds : Option[Int] = None,
  group : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : StatusDetails = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : StatusDetails = copy(name = name.map(f))

  /** Returns a new data with causes set to new value */
  def withCauses(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]) : StatusDetails = copy(causes = Some(value))
  /** Appends new values to causes */
  def addCauses(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause*) : StatusDetails = copy(causes = Some(causes.fold(newValues)(_ ++ newValues)))
  /** if causes has a value, transforms to the result of function*/
  def mapCauses(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]) : StatusDetails = copy(causes = causes.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : StatusDetails = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : StatusDetails = copy(uid = uid.map(f))

  /** Returns a new data with retryAfterSeconds set to new value */
  def withRetryAfterSeconds(value: Int) : StatusDetails = copy(retryAfterSeconds = Some(value))
  /** if retryAfterSeconds has a value, transforms to the result of function*/
  def mapRetryAfterSeconds(f: Int => Int) : StatusDetails = copy(retryAfterSeconds = retryAfterSeconds.map(f))

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : StatusDetails = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : StatusDetails = copy(group = group.map(f))
}

