package io.k8s.api.rbac.v1


/** RoleRef contains information that points to the role being used */
final case class RoleRef(
  apiGroup : String,
  name : String
) {

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : RoleRef = copy(apiGroup = value)
  /** transforms apiGroup to result of function */
  def mapApiGroup(f: String => String) : RoleRef = copy(apiGroup = f(apiGroup))

  /** Returns a new data with name set to new value */
  def withName(value: String) : RoleRef = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : RoleRef = copy(name = f(name))
}

