package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding. */
final case class ClusterRole(
  aggregationRule : Option[io.k8s.api.rbac.v1.AggregationRule] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  rules : Option[Seq[io.k8s.api.rbac.v1.PolicyRule]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRole", "v1")


  /** Returns a new data with aggregationRule set to new value */
  def withAggregationRule(value: io.k8s.api.rbac.v1.AggregationRule) : ClusterRole = copy(aggregationRule = Some(value))
  /** if aggregationRule has a value, transforms to the result of function*/
  def mapAggregationRule(f: io.k8s.api.rbac.v1.AggregationRule => io.k8s.api.rbac.v1.AggregationRule) : ClusterRole = copy(aggregationRule = aggregationRule.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRole = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRole = copy(metadata = metadata.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.rbac.v1.PolicyRule]) : ClusterRole = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.rbac.v1.PolicyRule*) : ClusterRole = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.rbac.v1.PolicyRule] => Seq[io.k8s.api.rbac.v1.PolicyRule]) : ClusterRole = copy(rules = rules.map(f))
}

