package io.k8s.api.networking.v1


/** NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from. */
final case class NetworkPolicyIngressRule(
  from : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None,
  ports : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None
) {

  /** Returns a new data with from set to new value */
  def withFrom(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyIngressRule = copy(from = Some(value))
  /** Appends new values to from */
  def addFrom(newValues: io.k8s.api.networking.v1.NetworkPolicyPeer*) : NetworkPolicyIngressRule = copy(from = Some(from.fold(newValues)(_ ++ newValues)))
  /** if from has a value, transforms to the result of function*/
  def mapFrom(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer] => Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyIngressRule = copy(from = from.map(f))

  /** Returns a new data with ports set to new value */
  def withPorts(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyIngressRule = copy(ports = Some(value))
  /** Appends new values to ports */
  def addPorts(newValues: io.k8s.api.networking.v1.NetworkPolicyPort*) : NetworkPolicyIngressRule = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))
  /** if ports has a value, transforms to the result of function*/
  def mapPorts(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPort] => Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyIngressRule = copy(ports = ports.map(f))
}

