package io.k8s.api.core.v1


/** A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values. */
final case class ScopedResourceSelectorRequirement(
  operator : String,
  scopeName : String,
  values : Option[Seq[String]] = None
) {

  /** Returns a new data with operator set to new value */
  def withOperator(value: String) : ScopedResourceSelectorRequirement = copy(operator = value)
  /** transforms operator to result of function */
  def mapOperator(f: String => String) : ScopedResourceSelectorRequirement = copy(operator = f(operator))

  /** Returns a new data with scopeName set to new value */
  def withScopeName(value: String) : ScopedResourceSelectorRequirement = copy(scopeName = value)
  /** transforms scopeName to result of function */
  def mapScopeName(f: String => String) : ScopedResourceSelectorRequirement = copy(scopeName = f(scopeName))

  /** Returns a new data with values set to new value */
  def withValues(value: Seq[String]) : ScopedResourceSelectorRequirement = copy(values = Some(value))
  /** Appends new values to values */
  def addValues(newValues: String*) : ScopedResourceSelectorRequirement = copy(values = Some(values.fold(newValues)(_ ++ newValues)))
  /** if values has a value, transforms to the result of function*/
  def mapValues(f: Seq[String] => Seq[String]) : ScopedResourceSelectorRequirement = copy(values = values.map(f))
}

