package io.k8s.api.core.v1


/** PodCondition contains details for the current condition of this pod. */
final case class PodCondition(
  status : String,
  `type` : String,
  lastProbeTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : PodCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : PodCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PodCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PodCondition = copy(`type` = f(`type`))

  /** Returns a new data with lastProbeTime set to new value */
  def withLastProbeTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastProbeTime = Some(value))
  /** if lastProbeTime has a value, transforms to the result of function*/
  def mapLastProbeTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastProbeTime = lastProbeTime.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : PodCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : PodCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : PodCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : PodCondition = copy(message = message.map(f))
}

