package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts. */
final case class Pod(
  status : Option[io.k8s.api.core.v1.PodStatus] = None,
  spec : Option[io.k8s.api.core.v1.PodSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Pod", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.PodStatus) : Pod = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.PodStatus => io.k8s.api.core.v1.PodStatus) : Pod = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PodSpec) : Pod = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.PodSpec => io.k8s.api.core.v1.PodSpec) : Pod = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Pod = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Pod = copy(metadata = metadata.map(f))
}

