package io.k8s.api.core.v1


/** Represents a Photon Controller persistent disk resource. */
final case class PhotonPersistentDiskVolumeSource(
  pdID : String,
  fsType : Option[String] = None
) {

  /** Returns a new data with pdID set to new value */
  def withPdID(value: String) : PhotonPersistentDiskVolumeSource = copy(pdID = value)
  /** transforms pdID to result of function */
  def mapPdID(f: String => String) : PhotonPersistentDiskVolumeSource = copy(pdID = f(pdID))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : PhotonPersistentDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : PhotonPersistentDiskVolumeSource = copy(fsType = fsType.map(f))
}

