package io.k8s.api.core.v1


/** NodeSpec describes the attributes that a node is created with. */
final case class NodeSpec(
  externalID : Option[String] = None,
  taints : Option[Seq[io.k8s.api.core.v1.Taint]] = None,
  configSource : Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  unschedulable : Option[Boolean] = None,
  podCIDR : Option[String] = None,
  providerID : Option[String] = None,
  podCIDRs : Option[Seq[String]] = None
) {

  /** Returns a new data with externalID set to new value */
  def withExternalID(value: String) : NodeSpec = copy(externalID = Some(value))
  /** if externalID has a value, transforms to the result of function*/
  def mapExternalID(f: String => String) : NodeSpec = copy(externalID = externalID.map(f))

  /** Returns a new data with taints set to new value */
  def withTaints(value: Seq[io.k8s.api.core.v1.Taint]) : NodeSpec = copy(taints = Some(value))
  /** Appends new values to taints */
  def addTaints(newValues: io.k8s.api.core.v1.Taint*) : NodeSpec = copy(taints = Some(taints.fold(newValues)(_ ++ newValues)))
  /** if taints has a value, transforms to the result of function*/
  def mapTaints(f: Seq[io.k8s.api.core.v1.Taint] => Seq[io.k8s.api.core.v1.Taint]) : NodeSpec = copy(taints = taints.map(f))

  /** Returns a new data with configSource set to new value */
  def withConfigSource(value: io.k8s.api.core.v1.NodeConfigSource) : NodeSpec = copy(configSource = Some(value))
  /** if configSource has a value, transforms to the result of function*/
  def mapConfigSource(f: io.k8s.api.core.v1.NodeConfigSource => io.k8s.api.core.v1.NodeConfigSource) : NodeSpec = copy(configSource = configSource.map(f))

  /** Returns a new data with unschedulable set to new value */
  def withUnschedulable(value: Boolean) : NodeSpec = copy(unschedulable = Some(value))
  /** if unschedulable has a value, transforms to the result of function*/
  def mapUnschedulable(f: Boolean => Boolean) : NodeSpec = copy(unschedulable = unschedulable.map(f))

  /** Returns a new data with podCIDR set to new value */
  def withPodCIDR(value: String) : NodeSpec = copy(podCIDR = Some(value))
  /** if podCIDR has a value, transforms to the result of function*/
  def mapPodCIDR(f: String => String) : NodeSpec = copy(podCIDR = podCIDR.map(f))

  /** Returns a new data with providerID set to new value */
  def withProviderID(value: String) : NodeSpec = copy(providerID = Some(value))
  /** if providerID has a value, transforms to the result of function*/
  def mapProviderID(f: String => String) : NodeSpec = copy(providerID = providerID.map(f))

  /** Returns a new data with podCIDRs set to new value */
  def withPodCIDRs(value: Seq[String]) : NodeSpec = copy(podCIDRs = Some(value))
  /** Appends new values to podCIDRs */
  def addPodCIDRs(newValues: String*) : NodeSpec = copy(podCIDRs = Some(podCIDRs.fold(newValues)(_ ++ newValues)))
  /** if podCIDRs has a value, transforms to the result of function*/
  def mapPodCIDRs(f: Seq[String] => Seq[String]) : NodeSpec = copy(podCIDRs = podCIDRs.map(f))
}

