package io.k8s.api.core.v1


/** LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace. */
final case class LocalObjectReference(
  name : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : LocalObjectReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : LocalObjectReference = copy(name = name.map(f))
}

