package io.k8s.api.core.v1


/** Maps a string key to a path within a volume. */
final case class KeyToPath(
  key : String,
  path : String,
  mode : Option[Int] = None
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : KeyToPath = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : KeyToPath = copy(key = f(key))

  /** Returns a new data with path set to new value */
  def withPath(value: String) : KeyToPath = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : KeyToPath = copy(path = f(path))

  /** Returns a new data with mode set to new value */
  def withMode(value: Int) : KeyToPath = copy(mode = Some(value))
  /** if mode has a value, transforms to the result of function*/
  def mapMode(f: Int => Int) : KeyToPath = copy(mode = mode.map(f))
}

