package io.k8s.api.core.v1


/** ExecAction describes a "run in container" action. */
final case class ExecAction(
  command : Option[Seq[String]] = None
) {

  /** Returns a new data with command set to new value */
  def withCommand(value: Seq[String]) : ExecAction = copy(command = Some(value))
  /** Appends new values to command */
  def addCommand(newValues: String*) : ExecAction = copy(command = Some(command.fold(newValues)(_ ++ newValues)))
  /** if command has a value, transforms to the result of function*/
  def mapCommand(f: Seq[String] => Seq[String]) : ExecAction = copy(command = command.map(f))
}

