package io.k8s.api.batch.v1


/** JobSpec describes how the job execution will look like. */
final case class JobSpec(
  template : io.k8s.api.core.v1.PodTemplateSpec,
  parallelism : Option[Int] = None,
  completionMode : Option[String] = None,
  podFailurePolicy : Option[io.k8s.api.batch.v1.PodFailurePolicy] = None,
  manualSelector : Option[Boolean] = None,
  suspend : Option[Boolean] = None,
  backoffLimit : Option[Int] = None,
  activeDeadlineSeconds : Option[Int] = None,
  completions : Option[Int] = None,
  ttlSecondsAfterFinished : Option[Int] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : JobSpec = copy(template = value)
  /** transforms template to result of function */
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : JobSpec = copy(template = f(template))

  /** Returns a new data with parallelism set to new value */
  def withParallelism(value: Int) : JobSpec = copy(parallelism = Some(value))
  /** if parallelism has a value, transforms to the result of function*/
  def mapParallelism(f: Int => Int) : JobSpec = copy(parallelism = parallelism.map(f))

  /** Returns a new data with completionMode set to new value */
  def withCompletionMode(value: String) : JobSpec = copy(completionMode = Some(value))
  /** if completionMode has a value, transforms to the result of function*/
  def mapCompletionMode(f: String => String) : JobSpec = copy(completionMode = completionMode.map(f))

  /** Returns a new data with podFailurePolicy set to new value */
  def withPodFailurePolicy(value: io.k8s.api.batch.v1.PodFailurePolicy) : JobSpec = copy(podFailurePolicy = Some(value))
  /** if podFailurePolicy has a value, transforms to the result of function*/
  def mapPodFailurePolicy(f: io.k8s.api.batch.v1.PodFailurePolicy => io.k8s.api.batch.v1.PodFailurePolicy) : JobSpec = copy(podFailurePolicy = podFailurePolicy.map(f))

  /** Returns a new data with manualSelector set to new value */
  def withManualSelector(value: Boolean) : JobSpec = copy(manualSelector = Some(value))
  /** if manualSelector has a value, transforms to the result of function*/
  def mapManualSelector(f: Boolean => Boolean) : JobSpec = copy(manualSelector = manualSelector.map(f))

  /** Returns a new data with suspend set to new value */
  def withSuspend(value: Boolean) : JobSpec = copy(suspend = Some(value))
  /** if suspend has a value, transforms to the result of function*/
  def mapSuspend(f: Boolean => Boolean) : JobSpec = copy(suspend = suspend.map(f))

  /** Returns a new data with backoffLimit set to new value */
  def withBackoffLimit(value: Int) : JobSpec = copy(backoffLimit = Some(value))
  /** if backoffLimit has a value, transforms to the result of function*/
  def mapBackoffLimit(f: Int => Int) : JobSpec = copy(backoffLimit = backoffLimit.map(f))

  /** Returns a new data with activeDeadlineSeconds set to new value */
  def withActiveDeadlineSeconds(value: Int) : JobSpec = copy(activeDeadlineSeconds = Some(value))
  /** if activeDeadlineSeconds has a value, transforms to the result of function*/
  def mapActiveDeadlineSeconds(f: Int => Int) : JobSpec = copy(activeDeadlineSeconds = activeDeadlineSeconds.map(f))

  /** Returns a new data with completions set to new value */
  def withCompletions(value: Int) : JobSpec = copy(completions = Some(value))
  /** if completions has a value, transforms to the result of function*/
  def mapCompletions(f: Int => Int) : JobSpec = copy(completions = completions.map(f))

  /** Returns a new data with ttlSecondsAfterFinished set to new value */
  def withTtlSecondsAfterFinished(value: Int) : JobSpec = copy(ttlSecondsAfterFinished = Some(value))
  /** if ttlSecondsAfterFinished has a value, transforms to the result of function*/
  def mapTtlSecondsAfterFinished(f: Int => Int) : JobSpec = copy(ttlSecondsAfterFinished = ttlSecondsAfterFinished.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : JobSpec = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : JobSpec = copy(selector = selector.map(f))
}

