package io.k8s.api.apps.v1


/** DaemonSetSpec is the specification of a daemon set. */
final case class DaemonSetSpec(
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  minReadySeconds : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  updateStrategy : Option[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = None
) {

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : DaemonSetSpec = copy(template = value)
  /** transforms template to result of function */
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : DaemonSetSpec = copy(template = f(template))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DaemonSetSpec = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DaemonSetSpec = copy(selector = f(selector))

  /** Returns a new data with minReadySeconds set to new value */
  def withMinReadySeconds(value: Int) : DaemonSetSpec = copy(minReadySeconds = Some(value))
  /** if minReadySeconds has a value, transforms to the result of function*/
  def mapMinReadySeconds(f: Int => Int) : DaemonSetSpec = copy(minReadySeconds = minReadySeconds.map(f))

  /** Returns a new data with revisionHistoryLimit set to new value */
  def withRevisionHistoryLimit(value: Int) : DaemonSetSpec = copy(revisionHistoryLimit = Some(value))
  /** if revisionHistoryLimit has a value, transforms to the result of function*/
  def mapRevisionHistoryLimit(f: Int => Int) : DaemonSetSpec = copy(revisionHistoryLimit = revisionHistoryLimit.map(f))

  /** Returns a new data with updateStrategy set to new value */
  def withUpdateStrategy(value: io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : DaemonSetSpec = copy(updateStrategy = Some(value))
  /** if updateStrategy has a value, transforms to the result of function*/
  def mapUpdateStrategy(f: io.k8s.api.apps.v1.DaemonSetUpdateStrategy => io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : DaemonSetSpec = copy(updateStrategy = updateStrategy.map(f))
}

