package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClassList is a collection of classes. */
final case class ResourceClassList(
  items : Seq[io.k8s.api.resource.v1alpha1.ResourceClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClassList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha1.ResourceClass]) : ResourceClassList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha1.ResourceClass*) : ResourceClassList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha1.ResourceClass] => Seq[io.k8s.api.resource.v1alpha1.ResourceClass]) : ResourceClassList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClassList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClassList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClassList.encoder.apply(this)
}

object ResourceClassList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClassList] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClassList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClassList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClassList] = new Decoder[ResourceClassList] {
      def apply[T : Reader](t: T): Either[String, ResourceClassList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha1.ResourceClass]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ResourceClassList (
          items = items,
          metadata = metadata
        )
    }
}

