package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodScheduling objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class PodScheduling(
  spec : io.k8s.api.resource.v1alpha1.PodSchedulingSpec,
  status : Option[io.k8s.api.resource.v1alpha1.PodSchedulingStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "PodScheduling", "v1alpha1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha1.PodSchedulingSpec) : PodScheduling = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha1.PodSchedulingSpec => io.k8s.api.resource.v1alpha1.PodSchedulingSpec) : PodScheduling = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.resource.v1alpha1.PodSchedulingStatus) : PodScheduling = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.resource.v1alpha1.PodSchedulingStatus => io.k8s.api.resource.v1alpha1.PodSchedulingStatus) : PodScheduling = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodScheduling = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodScheduling = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodScheduling.encoder.apply(this)
}

object PodScheduling {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.PodScheduling] = new Encoder[io.k8s.api.resource.v1alpha1.PodScheduling] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.PodScheduling) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodScheduling] = new Decoder[PodScheduling] {
      def apply[T : Reader](t: T): Either[String, PodScheduling] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha1.PodSchedulingSpec]("spec")
          status <- obj.readOpt[io.k8s.api.resource.v1alpha1.PodSchedulingStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PodScheduling (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

