package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once). */
final case class MetricSpec(
  `type` : String,
  `object` : Option[io.k8s.api.autoscaling.v2beta2.ObjectMetricSource] = None,
  external : Option[io.k8s.api.autoscaling.v2beta2.ExternalMetricSource] = None,
  containerResource : Option[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource] = None,
  resource : Option[io.k8s.api.autoscaling.v2beta2.ResourceMetricSource] = None,
  pods : Option[io.k8s.api.autoscaling.v2beta2.PodsMetricSource] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : MetricSpec = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : MetricSpec = copy(`type` = f(`type`))

  /** Returns a new data with `object` set to new value */
  def withObject(value: io.k8s.api.autoscaling.v2beta2.ObjectMetricSource) : MetricSpec = copy(`object` = Some(value))
  /** if `object` has a value, transforms to the result of function*/
  def mapObject(f: io.k8s.api.autoscaling.v2beta2.ObjectMetricSource => io.k8s.api.autoscaling.v2beta2.ObjectMetricSource) : MetricSpec = copy(`object` = `object`.map(f))

  /** Returns a new data with external set to new value */
  def withExternal(value: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource) : MetricSpec = copy(external = Some(value))
  /** if external has a value, transforms to the result of function*/
  def mapExternal(f: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource => io.k8s.api.autoscaling.v2beta2.ExternalMetricSource) : MetricSpec = copy(external = external.map(f))

  /** Returns a new data with containerResource set to new value */
  def withContainerResource(value: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource) : MetricSpec = copy(containerResource = Some(value))
  /** if containerResource has a value, transforms to the result of function*/
  def mapContainerResource(f: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource => io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource) : MetricSpec = copy(containerResource = containerResource.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.autoscaling.v2beta2.ResourceMetricSource) : MetricSpec = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: io.k8s.api.autoscaling.v2beta2.ResourceMetricSource => io.k8s.api.autoscaling.v2beta2.ResourceMetricSource) : MetricSpec = copy(resource = resource.map(f))

  /** Returns a new data with pods set to new value */
  def withPods(value: io.k8s.api.autoscaling.v2beta2.PodsMetricSource) : MetricSpec = copy(pods = Some(value))
  /** if pods has a value, transforms to the result of function*/
  def mapPods(f: io.k8s.api.autoscaling.v2beta2.PodsMetricSource => io.k8s.api.autoscaling.v2beta2.PodsMetricSource) : MetricSpec = copy(pods = pods.map(f))
}

object MetricSpec {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2beta2.MetricSpec] = new Encoder[io.k8s.api.autoscaling.v2beta2.MetricSpec] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2beta2.MetricSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("object", o.`object`)
            .write("external", o.external)
            .write("containerResource", o.containerResource)
            .write("resource", o.resource)
            .write("pods", o.pods)
            .build
        }
    }

    implicit val decoder: Decoder[MetricSpec] = new Decoder[MetricSpec] {
      def apply[T : Reader](t: T): Either[String, MetricSpec] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          `object` <- obj.readOpt[io.k8s.api.autoscaling.v2beta2.ObjectMetricSource]("object")
          external <- obj.readOpt[io.k8s.api.autoscaling.v2beta2.ExternalMetricSource]("external")
          containerResource <- obj.readOpt[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource]("containerResource")
          resource <- obj.readOpt[io.k8s.api.autoscaling.v2beta2.ResourceMetricSource]("resource")
          pods <- obj.readOpt[io.k8s.api.autoscaling.v2beta2.PodsMetricSource]("pods")
      } yield MetricSpec (
          `type` = `type`,
          `object` = `object`,
          external = external,
          containerResource = containerResource,
          resource = resource,
          pods = pods
        )
    }
}

