package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** Event represents a single event to a watched resource. */
final case class WatchEvent(
  `object` : io.k8s.apimachinery.pkg.runtime.RawExtension,
  `type` : String
) {

  /** Returns a new data with `object` set to new value */
  def withObject(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : WatchEvent = copy(`object` = value)
  /** transforms `object` to result of function */
  def mapObject(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : WatchEvent = copy(`object` = f(`object`))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : WatchEvent = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : WatchEvent = copy(`type` = f(`type`))
}

object WatchEvent {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent, T] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent, T] {
        def apply(o: io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("object", o.`object`)
            .write("type", o.`type`)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, WatchEvent] = new Decoder[T, WatchEvent] {
      def apply(t: T): Either[String, WatchEvent] = for {
          obj <- ObjectReader(t)
          `object` <- obj.read[io.k8s.apimachinery.pkg.runtime.RawExtension]("object")
          `type` <- obj.read[String]("type")
      } yield WatchEvent (
          `object` = `object`,
          `type` = `type`
        )
    }
}

