package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out. */
final case class Preconditions(
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : Preconditions = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : Preconditions = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : Preconditions = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : Preconditions = copy(uid = uid.map(f))
}

object Preconditions {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions, T] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions, T] {
        def apply(o: io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceVersion", o.resourceVersion)
            .write("uid", o.uid)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Preconditions] = new Decoder[T, Preconditions] {
      def apply(t: T): Either[String, Preconditions] = for {
          obj <- ObjectReader(t)
          resourceVersion <- obj.readOpt[String]("resourceVersion")
          uid <- obj.readOpt[String]("uid")
      } yield Preconditions (
          resourceVersion = resourceVersion,
          uid = uid
        )
    }
}

