package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** WebhookConversion describes how to call a conversion webhook */
final case class WebhookConversion(
  conversionReviewVersions : Seq[String],
  clientConfig : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] = None
) {

  /** Returns a new data with conversionReviewVersions set to new value */
  def withConversionReviewVersions(value: Seq[String]) : WebhookConversion = copy(conversionReviewVersions = value)
  /** Appends new values to conversionReviewVersions */
  def addConversionReviewVersions(newValues: String*) : WebhookConversion = copy(conversionReviewVersions = conversionReviewVersions ++ newValues)
  /** transforms conversionReviewVersions to result of function */
  def mapConversionReviewVersions(f: Seq[String] => Seq[String]) : WebhookConversion = copy(conversionReviewVersions = f(conversionReviewVersions))

  /** Returns a new data with clientConfig set to new value */
  def withClientConfig(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig) : WebhookConversion = copy(clientConfig = Some(value))
  /** if clientConfig has a value, transforms to the result of function*/
  def mapClientConfig(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig) : WebhookConversion = copy(clientConfig = clientConfig.map(f))
}

object WebhookConversion {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conversionReviewVersions", o.conversionReviewVersions)
            .write("clientConfig", o.clientConfig)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, WebhookConversion] = new Decoder[T, WebhookConversion] {
      def apply(t: T): Either[String, WebhookConversion] = for {
          obj <- ObjectReader(t)
          conversionReviewVersions <- obj.read[Seq[String]]("conversionReviewVersions")
          clientConfig <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig]("clientConfig")
      } yield WebhookConversion (
          conversionReviewVersions = conversionReviewVersions,
          clientConfig = clientConfig
        )
    }
}

