package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** WebhookClientConfig contains the information to make a TLS connection with the webhook. */
final case class WebhookClientConfig(
  caBundle : Option[String] = None,
  service : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference] = None,
  url : Option[String] = None
) {

  /** Returns a new data with caBundle set to new value */
  def withCaBundle(value: String) : WebhookClientConfig = copy(caBundle = Some(value))
  /** if caBundle has a value, transforms to the result of function*/
  def mapCaBundle(f: String => String) : WebhookClientConfig = copy(caBundle = caBundle.map(f))

  /** Returns a new data with service set to new value */
  def withService(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference) : WebhookClientConfig = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference) : WebhookClientConfig = copy(service = service.map(f))

  /** Returns a new data with url set to new value */
  def withUrl(value: String) : WebhookClientConfig = copy(url = Some(value))
  /** if url has a value, transforms to the result of function*/
  def mapUrl(f: String => String) : WebhookClientConfig = copy(url = url.map(f))
}

object WebhookClientConfig {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("caBundle", o.caBundle)
            .write("service", o.service)
            .write("url", o.url)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, WebhookClientConfig] = new Decoder[T, WebhookClientConfig] {
      def apply(t: T): Either[String, WebhookClientConfig] = for {
          obj <- ObjectReader(t)
          caBundle <- obj.readOpt[String]("caBundle")
          service <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference]("service")
          url <- obj.readOpt[String]("url")
      } yield WebhookClientConfig (
          caBundle = caBundle,
          service = service,
          url = url
        )
    }
}

