package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** ValidationRule describes a validation rule written in the CEL expression language. */
final case class ValidationRule(
  rule : String,
  message : Option[String] = None
) {

  /** Returns a new data with rule set to new value */
  def withRule(value: String) : ValidationRule = copy(rule = value)
  /** transforms rule to result of function */
  def mapRule(f: String => String) : ValidationRule = copy(rule = f(rule))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ValidationRule = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ValidationRule = copy(message = message.map(f))
}

object ValidationRule {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule, T] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule, T] {
        def apply(o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rule", o.rule)
            .write("message", o.message)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ValidationRule] = new Decoder[T, ValidationRule] {
      def apply(t: T): Either[String, ValidationRule] = for {
          obj <- ObjectReader(t)
          rule <- obj.read[String]("rule")
          message <- obj.readOpt[String]("message")
      } yield ValidationRule (
          rule = rule,
          message = message
        )
    }
}

