package io.k8s.api.storage.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** VolumeAttachmentList is a collection of VolumeAttachment objects. */
final case class VolumeAttachmentList(
  items : Seq[io.k8s.api.storage.v1.VolumeAttachment],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttachmentList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1.VolumeAttachment]) : VolumeAttachmentList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1.VolumeAttachment*) : VolumeAttachmentList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1.VolumeAttachment] => Seq[io.k8s.api.storage.v1.VolumeAttachment]) : VolumeAttachmentList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : VolumeAttachmentList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : VolumeAttachmentList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = VolumeAttachmentList.encoder[T].apply(this)
}

object VolumeAttachmentList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.storage.v1.VolumeAttachmentList, T] = new Encoder[io.k8s.api.storage.v1.VolumeAttachmentList, T] {
        def apply(o: io.k8s.api.storage.v1.VolumeAttachmentList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VolumeAttachmentList] = new Decoder[T, VolumeAttachmentList] {
      def apply(t: T): Either[String, VolumeAttachmentList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storage.v1.VolumeAttachment]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield VolumeAttachmentList (
          items = items,
          metadata = metadata
        )
    }
}

