package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterRoleBindingList is a collection of ClusterRoleBindings */
final case class ClusterRoleBindingList(
  items : Seq[io.k8s.api.rbac.v1.ClusterRoleBinding],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleBindingList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.rbac.v1.ClusterRoleBinding]) : ClusterRoleBindingList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.rbac.v1.ClusterRoleBinding*) : ClusterRoleBindingList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.rbac.v1.ClusterRoleBinding] => Seq[io.k8s.api.rbac.v1.ClusterRoleBinding]) : ClusterRoleBindingList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleBindingList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleBindingList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterRoleBindingList.encoder[T].apply(this)
}

object ClusterRoleBindingList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.rbac.v1.ClusterRoleBindingList, T] = new Encoder[io.k8s.api.rbac.v1.ClusterRoleBindingList, T] {
        def apply(o: io.k8s.api.rbac.v1.ClusterRoleBindingList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ClusterRoleBindingList] = new Decoder[T, ClusterRoleBindingList] {
      def apply(t: T): Either[String, ClusterRoleBindingList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.rbac.v1.ClusterRoleBinding]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ClusterRoleBindingList (
          items = items,
          metadata = metadata
        )
    }
}

