package io.k8s.api.rbac.v1

import dev.hnaderi.k8s.utils._

/** AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole */
final case class AggregationRule(
  clusterRoleSelectors : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]] = None
) {

  /** Returns a new data with clusterRoleSelectors set to new value */
  def withClusterRoleSelectors(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]) : AggregationRule = copy(clusterRoleSelectors = Some(value))
  /** Appends new values to clusterRoleSelectors */
  def addClusterRoleSelectors(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector*) : AggregationRule = copy(clusterRoleSelectors = Some(clusterRoleSelectors.fold(newValues)(_ ++ newValues)))
  /** if clusterRoleSelectors has a value, transforms to the result of function*/
  def mapClusterRoleSelectors(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]) : AggregationRule = copy(clusterRoleSelectors = clusterRoleSelectors.map(f))
}

object AggregationRule {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.rbac.v1.AggregationRule, T] = new Encoder[io.k8s.api.rbac.v1.AggregationRule, T] {
        def apply(o: io.k8s.api.rbac.v1.AggregationRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("clusterRoleSelectors", o.clusterRoleSelectors)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, AggregationRule] = new Decoder[T, AggregationRule] {
      def apply(t: T): Either[String, AggregationRule] = for {
          obj <- ObjectReader(t)
          clusterRoleSelectors <- obj.readOpt[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]]("clusterRoleSelectors")
      } yield AggregationRule (
          clusterRoleSelectors = clusterRoleSelectors
        )
    }
}

