package io.k8s.api.node.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** RuntimeClassList is a list of RuntimeClass objects. */
final case class RuntimeClassList(
  items : Seq[io.k8s.api.node.v1.RuntimeClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("node.k8s.io", "RuntimeClassList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.node.v1.RuntimeClass]) : RuntimeClassList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.node.v1.RuntimeClass*) : RuntimeClassList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.node.v1.RuntimeClass] => Seq[io.k8s.api.node.v1.RuntimeClass]) : RuntimeClassList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RuntimeClassList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RuntimeClassList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = RuntimeClassList.encoder[T].apply(this)
}

object RuntimeClassList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.node.v1.RuntimeClassList, T] = new Encoder[io.k8s.api.node.v1.RuntimeClassList, T] {
        def apply(o: io.k8s.api.node.v1.RuntimeClassList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, RuntimeClassList] = new Decoder[T, RuntimeClassList] {
      def apply(t: T): Either[String, RuntimeClassList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.node.v1.RuntimeClass]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield RuntimeClassList (
          items = items,
          metadata = metadata
        )
    }
}

