package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8 */
final case class NetworkPolicyEgressRule(
  ports : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None,
  to : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None
) {

  /** Returns a new data with ports set to new value */
  def withPorts(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyEgressRule = copy(ports = Some(value))
  /** Appends new values to ports */
  def addPorts(newValues: io.k8s.api.networking.v1.NetworkPolicyPort*) : NetworkPolicyEgressRule = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))
  /** if ports has a value, transforms to the result of function*/
  def mapPorts(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPort] => Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyEgressRule = copy(ports = ports.map(f))

  /** Returns a new data with to set to new value */
  def withTo(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyEgressRule = copy(to = Some(value))
  /** Appends new values to to */
  def addTo(newValues: io.k8s.api.networking.v1.NetworkPolicyPeer*) : NetworkPolicyEgressRule = copy(to = Some(to.fold(newValues)(_ ++ newValues)))
  /** if to has a value, transforms to the result of function*/
  def mapTo(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer] => Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyEgressRule = copy(to = to.map(f))
}

object NetworkPolicyEgressRule {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.NetworkPolicyEgressRule, T] = new Encoder[io.k8s.api.networking.v1.NetworkPolicyEgressRule, T] {
        def apply(o: io.k8s.api.networking.v1.NetworkPolicyEgressRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ports", o.ports)
            .write("to", o.to)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NetworkPolicyEgressRule] = new Decoder[T, NetworkPolicyEgressRule] {
      def apply(t: T): Either[String, NetworkPolicyEgressRule] = for {
          obj <- ObjectReader(t)
          ports <- obj.readOpt[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]]("ports")
          to <- obj.readOpt[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]]("to")
      } yield NetworkPolicyEgressRule (
          ports = ports,
          to = to
        )
    }
}

