package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** IngressClassList is a collection of IngressClasses. */
final case class IngressClassList(
  items : Seq[io.k8s.api.networking.v1.IngressClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressClassList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.networking.v1.IngressClass]) : IngressClassList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.networking.v1.IngressClass*) : IngressClassList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.networking.v1.IngressClass] => Seq[io.k8s.api.networking.v1.IngressClass]) : IngressClassList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressClassList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressClassList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = IngressClassList.encoder[T].apply(this)
}

object IngressClassList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.IngressClassList, T] = new Encoder[io.k8s.api.networking.v1.IngressClassList, T] {
        def apply(o: io.k8s.api.networking.v1.IngressClassList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, IngressClassList] = new Decoder[T, IngressClassList] {
      def apply(t: T): Either[String, IngressClassList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.networking.v1.IngressClass]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield IngressClassList (
          items = items,
          metadata = metadata
        )
    }
}

