package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** UserSubject holds detailed information for user-kind subject. */
final case class UserSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : UserSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : UserSubject = copy(name = f(name))
}

object UserSubject {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.UserSubject, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.UserSubject, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.UserSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, UserSubject] = new Decoder[T, UserSubject] {
      def apply(t: T): Either[String, UserSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield UserSubject (
          name = name
        )
    }
}

