package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationSpec specifies the configuration of a priority level. */
final case class PriorityLevelConfigurationSpec(
  `type` : String,
  limited : Option[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PriorityLevelConfigurationSpec = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PriorityLevelConfigurationSpec = copy(`type` = f(`type`))

  /** Returns a new data with limited set to new value */
  def withLimited(value: io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = Some(value))
  /** if limited has a value, transforms to the result of function*/
  def mapLimited(f: io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration => io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = limited.map(f))
}

object PriorityLevelConfigurationSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("limited", o.limited)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PriorityLevelConfigurationSpec] = new Decoder[T, PriorityLevelConfigurationSpec] {
      def apply(t: T): Either[String, PriorityLevelConfigurationSpec] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          limited <- obj.readOpt[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration]("limited")
      } yield PriorityLevelConfigurationSpec (
          `type` = `type`,
          limited = limited
        )
    }
}

