package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationReference contains information that points to the "request-priority" being used. */
final case class PriorityLevelConfigurationReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PriorityLevelConfigurationReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PriorityLevelConfigurationReference = copy(name = f(name))
}

object PriorityLevelConfigurationReference {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PriorityLevelConfigurationReference] = new Decoder[T, PriorityLevelConfigurationReference] {
      def apply(t: T): Either[String, PriorityLevelConfigurationReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield PriorityLevelConfigurationReference (
          name = name
        )
    }
}

