package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** FlowDistinguisherMethod specifies the method of a flow distinguisher. */
final case class FlowDistinguisherMethod(
  `type` : String
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : FlowDistinguisherMethod = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : FlowDistinguisherMethod = copy(`type` = f(`type`))
}

object FlowDistinguisherMethod {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod, T] = new Encoder[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, FlowDistinguisherMethod] = new Decoder[T, FlowDistinguisherMethod] {
      def apply(t: T): Either[String, FlowDistinguisherMethod] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
      } yield FlowDistinguisherMethod (
          `type` = `type`
        )
    }
}

